/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1322;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import twilightforest.TFSounds;
import twilightforest.entity.IHostileMount;
import twilightforest.entity.ai.ThrowRiderGoal;
import twilightforest.world.registration.biomes.BiomeKeys;

public class Yeti
extends class_1588
implements IHostileMount {
    private static final class_2940<Boolean> ANGER_FLAG = class_2945.method_12791(Yeti.class, (class_2941)class_2943.field_13323);
    private static final class_1322 ANGRY_MODIFIER = new class_1322("Angry follow range boost", 24.0, class_1322.class_1323.field_6328);

    public Yeti(class_1299<? extends Yeti> type, class_1937 world) {
        super(type, world);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new ThrowRiderGoal((class_1314)this, 1.0, false){

            @Override
            protected void method_6288(class_1309 victim, double p_190102_2_) {
                super.method_6288(victim, p_190102_2_);
                if (!Yeti.this.method_5685().isEmpty()) {
                    Yeti.this.method_5783(TFSounds.YETI_GRAB, 1.0f, 1.25f + Yeti.this.method_6051().nextFloat() * 0.5f);
                }
            }

            @Override
            public void method_6270() {
                if (!Yeti.this.method_5685().isEmpty()) {
                    Yeti.this.method_5783(TFSounds.YETI_THROW, 1.0f, 1.25f + Yeti.this.method_6051().nextFloat() * 0.5f);
                }
                super.method_6270();
            }
        });
        this.field_6201.method_6277(2, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(3, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    public static class_5132.class_5133 registerAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, 0.38).method_26868(class_5134.field_23721, 0.0).method_26868(class_5134.field_23717, 4.0);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ANGER_FLAG, (Object)false);
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_5685().isEmpty()) {
            this.method_5988().method_6226((class_1297)this.method_5685().get(0), 100.0f, 100.0f);
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_5529() != null && !source.method_5530()) {
            this.setAngry(true);
        }
        return super.method_5643(source, amount);
    }

    public boolean isAngry() {
        return (Boolean)this.field_6011.method_12789(ANGER_FLAG);
    }

    public void setAngry(boolean anger) {
        this.field_6011.method_12778(ANGER_FLAG, (Object)anger);
        if (!this.field_6002.field_9236) {
            if (anger) {
                if (!this.method_5996(class_5134.field_23717).method_6196(ANGRY_MODIFIER)) {
                    this.method_5996(class_5134.field_23717).method_26835(ANGRY_MODIFIER);
                }
            } else {
                this.method_5996(class_5134.field_23717).method_6202(ANGRY_MODIFIER);
            }
        }
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("Angry", this.isAngry());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setAngry(compound.method_10577("Angry"));
    }

    public void method_5865(class_1297 passenger) {
        class_243 riderPos = this.getRiderPosition(passenger);
        passenger.method_5814(riderPos.field_1352, riderPos.field_1351, riderPos.field_1350);
    }

    public double method_5621() {
        return 2.25;
    }

    private class_243 getRiderPosition(@Nullable class_1297 passenger) {
        if (passenger != null) {
            float distance = 0.4f;
            double dx = Math.cos((double)(this.method_36454() + 90.0f) * Math.PI / 180.0) * (double)distance;
            double dz = Math.sin((double)(this.method_36454() + 90.0f) * Math.PI / 180.0) * (double)distance;
            return new class_243(this.method_23317() + dx, this.method_23318() + this.method_5621() + passenger.method_5678(), this.method_23321() + dz);
        }
        return new class_243(this.method_23317(), this.method_23318(), this.method_23321());
    }

    public boolean canRiderInteract() {
        return true;
    }

    public static boolean yetiSnowyForestSpawnHandler(class_1299<? extends Yeti> entityType, class_5425 world, class_3730 reason, class_2338 pos, Random random) {
        Optional key = world.method_23753(pos).method_40230();
        if (Objects.equals(key, Optional.of(BiomeKeys.SNOWY_FOREST))) {
            return Yeti.method_20636(entityType, (class_1936)world, (class_3730)reason, (class_2338)pos, (Random)random);
        }
        return Yeti.normalYetiSpawnHandler(entityType, world, reason, pos, random);
    }

    public static boolean normalYetiSpawnHandler(class_1299<? extends class_1588> entity, class_5425 world, class_3730 reason, class_2338 pos, Random random) {
        return world.method_8407() != class_1267.field_5801 && Yeti.isValidLightLevel(world, pos, random) && Yeti.method_20636(entity, (class_1936)world, (class_3730)reason, (class_2338)pos, (Random)random);
    }

    public static boolean isValidLightLevel(class_5425 world, class_2338 blockPos, Random random) {
        Optional key = world.method_23753(blockPos).method_40230();
        if (world.method_8314(class_1944.field_9284, blockPos) > random.nextInt(32)) {
            return Objects.equals(key, Optional.of(BiomeKeys.SNOWY_FOREST));
        }
        int i = world.method_8410().method_8546() ? world.method_22346(blockPos, 10) : world.method_22339(blockPos);
        return i <= random.nextInt(8) || Objects.equals(key, Optional.of(BiomeKeys.SNOWY_FOREST));
    }

    public float method_6017() {
        return super.method_6017() + 0.55f;
    }

    @Nullable
    protected class_3414 method_5994() {
        return TFSounds.YETI_GROWL;
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return TFSounds.YETI_HURT;
    }

    protected class_3414 method_6002() {
        return TFSounds.YETI_DEATH;
    }
}

